%% PLOTTING READOUT CIRCUIT RESPONSE

%%
clc;
clear all;
close all;


%% Selecting file
list1 = {'readout_dim_over_V_VCC_param.csv',...         % Voltages with VCC tuned
         'readout_dim_over15u_VCC_tuned.csv',...        % Voltages with VCC tuned
         'readout_dim_over_I.csv',...                   % Currents; W=20um, L=1um
         'readout_dim_over15u_Vctrl=0.csv',...          % Currents; W=15um, L=1um
         'readout_dim_opt_Vctrl=0.csv',...              % Currents; W=1.5um, L=100n
         'readout_dim_over_I1_W_param.csv',...          % I1 with W tuned
         'readout_time_Vctrl_3_19.csv'...               % Vctrl, IDS, I1 in time
         };       
     
[indx1,tf1] = listdlg('ListString', list1,'SelectionMode','single',...
                      'PromptString','Select file');
file = list1{indx1};    % Selected file


switch file
%     case 'readout_dim_over_V_VCC_param.csv'
    case 'readout_dim_over15u_VCC_tuned.csv'
        %% Extracting data
        importfile(file);
        [raws,columns] = size(data);
        
        number_traces = columns/2;
        i = 1;
        j = 1;
        k = 1;
        
        labels_par = {'For V_{CC} = 1 V',...               % [V]                                             
                      'For V_{CC} = 2 V',...               % [V]
                      'For V_{CC} = 3 V',...               % [V]
                      'For V_{CC} = 4 V',...               % [V]
                      'For V_{CC} = 5 V',...               % [V]
                      };
        
        VREF = data(:,1);
    
        for i_VDS = (columns/2 + 1):2:columns
    
            VDS(:,i) = data(:,i_VDS+1);       % [V]
            
            labels_VDS(:,i) = labels_par(:,i);
    
            i = i + 1;
        
        end
        
        for j_VG0 = 1:2:(columns/2)
    
            VG0(:,j) = data(:,j_VG0+1);       % [V]
            
            labels_VG0(:,j) = labels_par(:,j);
    
            j = j + 1;
        
        end
        
        %% Figures
        for k = 1:columns/4
            
%             VGS0(:,k) = VG0(:,k) - VDS(:,k);

            figure(1);
    %         subplot(2,1,1);
            plot(VREF,VDS(:,k),...
                 'DisplayName',char(labels_VDS(:,k)),'LineWidth',1.5);
            pbaspect([1 1 1]);
            xlabel('V_{REF} [V]');
            ylabel('V_{DS} [V]');
            hold on;
            grid on;
        %     title('I_{DS} - V_{DS}')    
            legend('-DynamicLegend');
            legend('show');    
            legend('Location','northwest');
            
        end
        print -depsc epsFig_VDS_VCC_param_15u;


        for k = 1:columns/4
            
%             VGS0(:,k) = VG0(:,k) - VDS(:,k);

            figure(2);
    %         subplot(2,1,1);
            plot(VREF,VG0(:,k),...
                 'DisplayName',char(labels_VG0(:,k)),'LineWidth',1.5);
            pbaspect([1 1.5 1]);
            xlabel('V_{REF} [V]');
            ylabel('V_{G,0} [V]');
            hold on;
            grid on;
        %     title('I_{DS} - V_{DS}')    
            legend('-DynamicLegend');
            legend('show');    
            legend('Location','northwest');
            
        end
        print -depsc epsFig_VG0_VCC_param_15u;



%     case 'readout_dim_over_I.csv'
    case 'readout_dim_over15u_Vctrl=0.csv'
        %% Extracting data
        importfile(file);
        [raws,columns] = size(data);
        
        number_traces = columns/2;
        i = 1;
        j = 1;
        k = 1;
         
        labels_currents = {'I_{DS}',...              % [A]                                             
                           'I_{0}',...               % [A]
                           'I_{2}',...               % [A]
                           'I_{1}',...               % [A]
                           };
        
        VREF = data(:,1);
        
        for i_I = 1:2:columns
    
            I(:,i) = data(:,i_I+1);       % [V]
            
            labels_I(:,i) = labels_currents(:,i);
    
            i = i + 1;
        
        end

        %% Figures
        for k = 1:columns/2
            figure(1);
    %         subplot(2,1,1);
            plot(VREF,I(:,k)*1e6,...        % [in uA]
                 'DisplayName',char(labels_I(:,k)),'LineWidth',1.5);
%             pbaspect([1 1 1]);
            xlabel('V_{REF} [V]');
            ylabel('Currents [\muA]');
            hold on;
            grid on;
        %     title('I_{DS} - V_{DS}')    
            legend('-DynamicLegend');
            legend('show');    
            legend('Location','northeast');
        end
        print -depsc epsFig_readout_I;
    
    case 'readout_dim_opt_Vctrl=0.csv'
        %% Extracting data
        importfile(file);
        [raws,columns] = size(data);
        
        number_traces = columns/2;
        i = 1;
        j = 1;
        k = 1;
         
        labels_currents = {'I_{DS}',...              % [A]                                             
                           'I_{0}',...               % [A]
                           'I_{2}',...               % [A]
                           'I_{1}',...               % [A]
                           };
        
        VREF = data(:,1);
        
        for i_I = 1:2:columns
    
            I(:,i) = data(:,i_I+1);       % [V]
            
            labels_I(:,i) = labels_currents(:,i);
    
            i = i + 1;
        
        end

        %% Figures
        for k = 1:columns/2
            figure(1);
    %         subplot(2,1,1);
            plot(VREF,I(:,k)*1e6,...        % [in uA]
                 'DisplayName',char(labels_I(:,k)),'LineWidth',1.5);
%             pbaspect([1 1 1]);
            xlabel('V_{REF} [V]');
            ylabel('Currents [\muA]');
            ylim([0 50]);
            hold on;
            grid on;
        %     title('I_{DS} - V_{DS}')    
            legend('-DynamicLegend');
            legend('show');    
            legend('Location','northeast');
        end
        print -depsc epsFig_readout_I_opt;



    case 'readout_dim_over_I1_W_param.csv'

        %% Extracting data
        importfile(file);
        [raws,columns] = size(data);
        
        number_traces = columns/2;
        i = 1;
        j = 1;
        k = 1;
         
        labels_par = {'For W = 5 \mum',...                % [um]                                             
                      'For W = 10 \mum',...               % [um]
                      'For W = 15 \mum',...               % [um]
                      'For W = 20 \mum',...               % [um]
                      'For W = 25 \mum',...               % [um]
                      };
%         
        VREF = data(:,1);
%         
        for i_I1 = 1:2:columns
    
            I1(:,i) = data(:,i_I1+1);       % [A]
            
            labels_I1(:,i) = labels_par(:,i);
    
            i = i + 1;
        
        end

        %% Figures
        for k = 1:columns/2
            figure(1);
    %         subplot(2,1,1);
            plot(VREF,I1(:,k)*1e6,...        % [in uA]
                 'DisplayName',char(labels_I1(:,k)),'LineWidth',1.5);
%             pbaspect([1 1 1]);
            xlabel('V_{REF} [V]');
            ylabel('I_{1} [\muA]');
            hold on;
            grid on;
        %     title('I_{DS} - V_{DS}')    
            legend('-DynamicLegend');
            legend('show');    
            legend('Location','northeast');
            
        
        end
        print -depsc epsFig;
    
    
    case 'readout_time_Vctrl_3_19.csv'
        %% Extracting data
        importfile(file);
        [raws,columns] = size(data);
        
        number_traces = columns/2;
        i = 1;
        j = 1;
        k = 1;
        
        label_VCTRL = 'V_{CTRL}';                    % [V]

        labels_currents = {'I_{DS}',...              % [A]                                           
                    'I_{1}',...               % [A]
                    };
        color_curr = {'green','red'};

        time = data(:,1);               % [s]
        VCTRL = data(:,2);              % [V]
        
        for i_I = 4:2:columns
        
            I(:,i) = data(:,i_I);       % [A] 

            labels_I(:,i) = labels_currents(:,i);
            color(:,i) = color_curr(:,i);
            
            i = i + 1;
        
        end
        
        IDS = I(:,1);
        I1 = I(:,2);
        Delta_I = I1 - IDS;
        
        

        



        %% Figures
        figure(1);
        subplot(2,1,1);
        plot(time*1e9,VCTRL,...        % [in ns]
             'DisplayName',char(label_VCTRL),'LineWidth',1.5);
%         pbaspect([1 1 1]);
        xlabel('Time [ns]');
        ylabel('V_{CTRL} [V]');
        hold on;
        grid on;
        xlim([0 125]);
        legend('-DynamicLegend');
        legend('show');    
        legend('Location','northeast');     


        for k = 1:2
            figure(1);
            subplot(2,1,2);
            plot(time*1e9,I(:,k)*1e6,...        % [in ns, in uA]
                 'DisplayName',char(labels_I(:,k)),...
                 'Color',char(color{:,k}),...
                 'LineWidth',1.5);
%             pbaspect([1 1 1]);
            xlabel('Time [ns]');
            ylabel('Currents [\muA]');
            hold on;
            grid on;
            xlim([0 125]);
            legend('-DynamicLegend');
            legend('show');    
            legend('Location','southeast');     
        end
        


%         print -depsc epsFig_readout_time;
        
        figure(2);
        plot(time*1e9,Delta_I*1e6,'LineWidth',1.5)        % [in ns]
%         pbaspect([1 1 1]);
        xlabel('Time [ns]');
        ylabel('\DeltaI [\muA]');
        hold on;
        grid on;
%         xlim([0 125]);
%         legend('-DynamicLegend');
%         legend('show');    
%         legend('Location','northeast');     
        
%         %% Calculation of average values of currents
%         k_spikes = find(abs(Delta_I) > 1e-6);
%         
%         IDS(k_spikes) = [];
%         I1(k_spikes) = [];
% 
% %         avg_IDS = (max(IDS)+min(IDS))/2;
% %         avg_I1 = (max(I1)+min(I1))/2;
% 
%         jj_IDS_1 = find(IDS < mean(IDS));
%         jj_IDS_2 = find(IDS > mean(IDS));
%         jj_I1_1 = find(IDS < mean(I1));
%         jj_I1_2 = find(IDS > mean(I1));
% 
% 
%         % Preallocation
%         IDS_1 = zeros(length(jj_IDS_1),1);
%         IDS_2 = zeros(length(jj_IDS_2),1);
%         I1_1 = zeros(length(jj_I1_1),1);
%         I1_2 = zeros(length(jj_I1_2),1);
%         
%         % Values of currents in the two phases
%         IDS_1 = I(jj_IDS_1,1);        
%         IDS_2 = I(jj_IDS_2,1);
%         I1_1 = I(jj_I1_1,2);
%         I1_2 = I(jj_I1_2,2);
%         
% 
%         % Average and standard deviation of currents
%         IDS_1_avg = mean(IDS_1)
%         IDS_2_avg = mean(IDS_2)
%         I1_1_avg = mean(I1_1)
%         I1_2_avg = mean(I1_2)
%         
%         figure(1);
%         line(get(gca,'xlim'),[IDS_1_avg*1e6 IDS_1_avg*1e6],...
%              'Color','r','Linewidth',1.5);
%         line(get(gca,'xlim'),[IDS_2_avg*1e6 IDS_2_avg*1e6],...
%              'Color','k','Linewidth',1.5);
%         line(get(gca,'xlim'),[I1_1_avg*1e6 I1_1_avg*1e6],...
%              'Color','g','Linewidth',1.5);
%         line(get(gca,'xlim'),[I1_2_avg*1e6 I1_2_avg*1e6],...
%              'Color','b','Linewidth',1.5);

end

